/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ConvenientStackHandler
extends ItemStackHandler
implements ICapabilityProvider {
    private final ItemStack stack;
    private final int size;

    public ConvenientStackHandler(ItemStack stack, int size) {
        this.stack = stack;
        this.size = size;
    }

    private ListTag getStackList() {
        ListTag list;
        String key = "convenient_inventory";
        if (!this.stack.m_41619_() && this.stack.m_41782_() && this.stack.m_41784_().m_128441_(key)) {
            list = this.stack.m_41784_().m_128437_(key, 10);
        } else {
            list = new ListTag();
            this.stack.m_41784_().m_128365_(key, (Tag)list);
        }
        while (list.size() < this.size) {
            list.add((Object)new CompoundTag());
        }
        return list;
    }

    private void writeStack(int index, @Nonnull ItemStack stack) {
        this.getStackList().set(index, (Tag)stack.serializeNBT());
        this.onContentsChanged(index);
    }

    private ItemStack readStack(int index) {
        return ItemStack.m_41712_((CompoundTag)this.getStackList().m_128728_(index));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.writeStack(slot, stack);
        this.onContentsChanged(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.readStack(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            this.writeStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.writeStack(slot, ItemStack.f_41583_);
            }
            return existing;
        }
        if (!simulate) {
            this.writeStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this));
    }
}

